#!/bin/bash

# Copyright 2009-2016 Avago Technologies. All rights reserved.

KITNAME=elxflashOffline
SUCCESS=0
FAILURE=1
FALSE=0
TRUE=1

UNINSTALL_OCM=$FALSE
UNINSTALL_APPS=$TRUE

UNINSTALL_STATUS=0
ELXFLASHONLINE_STATUS=0
ELXFLASHOFFLINE_STATUS=0
LINLPCFG_STATUS=0
ELXFLASHOFFLINE_NOT_INSTALLED=0
ELXLINLPCFG_NOT_INSTALLED=0

CLU_OS=""
CLU_ARCH=""
CLU_OS_FULL="NONE"


LOGFILE_NAME="offline-install.log"
LOGFILE="/usr/sbin/linlpcfg/${LOGFILE_NAME}"
# Function:  log_message()
#
# Description:
#   Print the strings passed as parameters to both STDOUT as well as
#   to a log file.
#
# Parameters:
#   A series of strings.
#
# Returns:
#   0 on success.
log_message()
{
    local ECHO_OPTIONS
    LOGDIRECTORY=${LOGFILE%/*}
    if [ ! -d ${LOGDIRECTORY} ] ; then
        mkdir -p ${LOGDIRECTORY}
    fi

    if [ $# -eq 0 ] ; then
        echo "" | tee -a ${LOGFILE}
    elif [ -z "$1" ] ; then
        echo "" | tee -a ${LOGFILE}
    elif [ "$1" = "-init" ] ; then
        echo "$0 - $(date)" >> ${LOGFILE}
    else
        while [ -n "$1" ] ; do
            if [ "${1:0:1}" = "-" ] ; then
                ECHO_OPTIONS="${1}"
            else
                echo ${ECHO_OPTIONS} "$1" | tee -a ${LOGFILE}
            fi
            shift
        done
    fi
    return $SUCCESS
}


#
# Get environment data
#
determine_arch()
{
    CLU_ARCH=$(uname -m)
    case ${CLU_ARCH} in
        i[3456]86)
            CLU_ARCH=i386
            ;;
        
        x86_64)
            CLU_ARCH=x86_64
            ;;
        
        ppc64)
            CLU_ARCH=ppc64
            ;;
        
        ia64)
            CLU_ARCH=ia64
            ;;
        
        *)
            log_message "ERROR: Unsupported architecture $CLU_ARCH"
            exit $FAILURE
            ;;
    esac
}


#
# Print a help message
#
function print_help()
{
    echo "This script accepts the following options:"
    echo "./uninstall.sh                        - Uninstall ElxflashOffline and Elxlinlpcfg."
#if [ "$KITNAME" != "elxflashOffline-citrix" ]; then
    #echo "./uninstall.sh -f,--uninstall_lpfc    - Uninstall ElxflashOffline, Elxlinlpcfg and lpfc driver."
    #echo "./uninstall.sh -n,--uninstall_nic     - Uninstall ElxflashOffline, Elxlinlpcfg, and be2net drivers."
    #echo "./uninstall.sh -s,--uninstall_iscsi   - Uninstall ElxflashOffline, Elxlinlpcfg, and be2iscsi drivers."
    #echo "./uninstall.sh -u,--uninstall_all     - Uninstall ElxflashOffline, Elxlinlpcfg, be2net, be2iscsi, and lpfc drivers."
#fi
    echo "./uninstall.sh -h                     - Display a summary of all available switches."
    echo ""
}


#
# Uninstall ElxflashOnline
#
function uninstall_elxflashOnline
{
    if [ $UNINSTALL_APPS -eq $TRUE ]; then
        rpm -q --quiet elxflashOnline
        if [ $? -eq 0 ]; then
            ELXFLASHONLINEQUERY=`rpm -q elxflashOnline`
            log_message "Uninstalling $ELXFLASHONLINEQUERY..."
            rpm -e $ELXFLASHONLINEQUERY
            ELXFLASHONLINE_STATUS=$?
            if [ $ELXFLASHONLINE_STATUS -eq 0 ];then
                log_message "Uninstalling $ELXFLASHONLINEQUERY completed successfully"
            else
                UNINSTALL_STATUS=$FAILURE
                log_message "An error occurred while uninstalling $ELXFLASHONLINEQUERY"
            fi
            log_message ""
        fi
    fi
}


#
# Uninstall OCManager
#
function uninstall_ocmanager()
{
    if [ $UNINSTALL_OCM -eq $TRUE ]; then
        rpm -q --quiet elxocmgui
        if [ $? -eq 0 ]; then
            ELXOCMGUIQUERY=`rpm -q elxocmgui`
            log_message "Uninstalling $ELXOCMGUIQUERY..."
            rpm -e $ELXOCMGUIQUERY
            STATUS=$?
            if [ $STATUS -eq 0 ];then
                log_message "Uninstalling $ELXOCMGUIQUERY completed successfully"
            else
                UNINSTALL_STATUS=$FAILURE
                log_message "An error occurred while uninstalling $ELXOCMGUIQUERY"
            fi
            log_message ""
        fi
        
        rpm -q --quiet elxocmjvm
        if [ $? -eq 0 ]; then
            ELXOCMJVMQUERY=`rpm -q elxocmjvm`
            log_message "Uninstalling $ELXOCMJVMQUERY..."
            rpm -e $ELXOCMJVMQUERY
            STATUS=$?
            if [ $STATUS -eq 0 ];then
                log_message "Uninstalling $ELXOCMJVMQUERY completed successfully"
            else
                UNINSTALL_STATUS=$FAILURE
                log_message "An error occurred while uninstalling $ELXOCMJVMQUERY"
            fi
            log_message ""
        fi
        
        rpm -q --quiet elxocmcore
        if [ $? -eq 0 ]; then
            ELXOCMCOREQUERY=`rpm -q elxocmcore`
            log_message "Uninstalling $ELXOCMCOREQUERY..."
            rpm -e $ELXOCMCOREQUERY
            STATUS=$?
            if [ $STATUS -eq 0 ];then
                log_message "Uninstalling $ELXOCMCOREQUERY completed successfully"
            else
                UNINSTALL_STATUS=$FAILURE
                log_message "An error occurred while uninstalling $ELXOCMCOREQUERY"
            fi
            log_message ""
        fi
        
        rpm -q --quiet elxocmlibhbaapi
        if [ $? -eq 0 ]; then
            ELXOCMLIBHBAAPIQUERY=`rpm -q elxocmlibhbaapi`
            log_message "Uninstalling $ELXOCMLIBHBAAPIQUERY..."
            rpm -e $ELXOCMLIBHBAAPIQUERY
            STATUS=$?
            if [ $STATUS -eq 0 ];then
                log_message "Uninstalling $ELXOCMLIBHBAAPIQUERY completed successfully"
            else
                UNINSTALL_STATUS=$FAILURE
                log_message "An error occurred while uninstalling $ELXOCMLIBHBAAPIQUERY"
            fi
            log_message ""
        fi
        
        rpm -q --quiet elxocmlibhbaapi-32bit
        if [ $? -eq 0 ]; then
            ELXOCMLIBHBAAPIQUERY=`rpm -q elxocmlibhbaapi-32bit`
            log_message "Uninstalling $ELXOCMLIBHBAAPIQUERY..."
            rpm -e $ELXOCMLIBHBAAPIQUERY
            STATUS=$?
            if [ $STATUS -eq 0 ];then
                log_message "Uninstalling $ELXOCMLIBHBAAPIQUERY completed successfully"
            else
                UNINSTALL_STATUS=$FAILURE
                log_message "An error occurred while uninstalling $ELXOCMLIBHBAAPIQUERY"
            fi
            log_message ""
        fi
        
        rpm -q --quiet elxocmlibhbaapi-64bit
        if [ $? -eq 0 ]; then
            ELXOCMLIBHBAAPIQUERY=`rpm -q elxocmlibhbaapi-64bit`
            log_message "Uninstalling $ELXOCMLIBHBAAPIQUERY..."
            rpm -e $ELXOCMLIBHBAAPIQUERY
            STATUS=$?
            if [ $STATUS -eq 0 ];then
                log_message "Uninstalling $ELXOCMLIBHBAAPIQUERY completed successfully"
            else
                UNINSTALL_STATUS=$FAILURE
                log_message "An error occurred while uninstalling $ELXOCMLIBHBAAPIQUERY"
            fi
            log_message ""
        fi
    fi
}


#
# Uninstall ElxflashOffline
#
function uninstall_elxflashOffline
{
    if [ $UNINSTALL_APPS -eq $TRUE ]; then
        rpm -q --quiet elxflashOffline
        if [ $? -eq 0 ]; then
            ELXFLASHOFFLINEQUERY=`rpm -q elxflashOffline`
            log_message "Uninstalling $ELXFLASHOFFLINEQUERY..."
            rpm -e $ELXFLASHOFFLINEQUERY
            ELXFLASHOFFLINE_STATUS=$?
            if [ $ELXFLASHOFFLINE_STATUS -eq 0 ];then
                log_message "Uninstalling $ELXFLASHOFFLINEQUERY completed successfully"
            else
                UNINSTALL_STATUS=$FAILURE
                log_message "An error occurred while uninstalling $ELXFLASHOFFLINEQUERY"
            fi
            log_message ""
        else
            ELXFLASHOFFLINE_NOT_INSTALLED=$TRUE
        fi
    fi
}


#
# Uninstall Elxlinlpcfg
#
function uninstall_elxlinlpcfg()
{
    if [ $UNINSTALL_APPS -eq $TRUE ]; then
        rpm -q --quiet elxlinlpcfg
        if [ $? -eq 0 ]; then
            ELXLINLPCFGQUERY=`rpm -q elxlinlpcfg`
            log_message "Uninstalling $ELXLINLPCFGQUERY..."
            rpm -e $ELXLINLPCFGQUERY
            LINLPCFG_STATUS=$?
            if [ $LINLPCFG_STATUS -eq 0 ];then
                log_message "Uninstalling $ELXLINLPCFGQUERY completed successfully"
            else
                UNINSTALL_STATUS=$FAILURE
                log_message "An error occurred while uninstalling $ELXLINLPCFGQUERY"
            fi
            log_message ""
        else
            ELXLINLPCFG_NOT_INSTALLED=$TRUE
        fi
    fi
}


#############################################
# Begin script execution
# Evaluate the arguments that were used
#############################################
while [ $# -gt 0 ];
do
    case $1
    in
        -k|--uninstall_ocm)
            UNINSTALL_OCM=$TRUE
        ;;
        -h|--help)
            print_help
            exit $SUCCESS
        ;;
        *)
            echo "Invalid option - $1"
            SCRIPT_COMMAND="badoption"
        ;;
    esac
    shift
    
done

# Exit if an invalid parameter was specified by the user.
if [ -n "${SCRIPT_COMMAND}" ] && [ ${SCRIPT_COMMAND} = "badoption" ] ; then
    print_help
    exit 5
fi


#
# Initialize the log file.
#
log_message -init
determine_arch


#
# Uninstall the applications
#
uninstall_elxflashOnline
uninstall_ocmanager
uninstall_elxflashOffline
uninstall_elxlinlpcfg


if [ "$KITNAME" = "elxflashOffline_NIC_Only" ]; then
    if [ $ELXFLASHOFFLINE_NOT_INSTALLED -eq $TRUE ]; then
        log_message "$KITNAME is not installed."
        log_message ""
        exit $SUCCESS
    fi
fi

if [ "$KITNAME" = "elxflashOffline" ]; then
    if [ $ELXLINLPCFG_NOT_INSTALLED -eq $TRUE ] && \
       [ $ELXFLASHOFFLINE_NOT_INSTALLED -eq $TRUE ]; then
        log_message "$KITNAME is not installed."
        log_message ""
        exit $SUCCESS
    fi
fi

if [ $UNINSTALL_STATUS -eq $SUCCESS ]; then
    log_message "$KITNAME un-installation completed successfully!"
    log_message ""
    exit $SUCCESS
else
    log_message "$KITNAME un-installation failed!"
    log_message ""
    exit $FAILURE
fi

